document.addEventListener('DOMContentLoaded', () => {
    const form = document.getElementById('application-form');
    const messageDiv = document.getElementById('message');

    function showMessage(text, isError = false) {
        messageDiv.textContent = text;
        messageDiv.className = `message ${isError ? 'error' : 'success'}`;
        setTimeout(() => {
            messageDiv.className = 'message';
        }, 5000);
    }

    form.addEventListener('submit', async (e) => {
        e.preventDefault();

        const formData = new FormData(form);
        
        try {
            const response = await fetch('/api/apply', {
                method: 'POST',
                body: formData
            });

            const data = await response.json();

            if (response.ok) {
                showMessage('Application submitted successfully!');
                form.reset();
            } else {
                throw new Error(data.error || 'Failed to submit application');
            }
        } catch (error) {
            showMessage(error.message, true);
        }
    });
});